﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using GE.Visualisation;
using GE.Physics.Shapes;
using GE.Physics;
using Microsoft.Xna.Framework;

namespace GE.World.Entities
{
    class ShrapnelEntity : WorldEntity
    {
        /// <summary>
        /// Shrapnel's texture
        /// </summary>
        int _iIdTexture;

        /// <summary>
        /// Shrapnel's sprite
        /// </summary>
        int _iIdSprite;

        /// <summary>
        /// shrapnel's shape
        /// </summary>
        DynamicShapeRectangle _shape;

        /// <summary>
        /// Shrapnel's speed
        /// </summary>
        Vector2 _v2Speed;

        const float ACCELERATION_LIFE_TIME = 1000;
        int _iBirthTime;

        bool _bPreState;

        /// <summary>
        /// Id of the animation explosion
        /// </summary>
        int _iIdAnimationExplosion;

        /// <summary>
        /// Position offset of the animation
        /// </summary>
        Vector2 _v2AnimationOffset;

        /// <summary>
        /// Constructor
        /// </summary>
        public ShrapnelEntity()
            : base()
        {
            _iIdTexture = -1;
            _iIdSprite = -1;
            _iIdAnimationExplosion = -1;
            _shape = Physics.Physics.Instance.createDynamicRectangle(0, 0, Vector2.Zero, this);
            _shape._bCollisionEnable = false;
        }

        /// <summary>
        /// Initialise the entity. Load all the data which are not loaded during the level loading.
        /// </summary>
        public override void init()
        {
            _iIdTexture = Visu.Instance.loadTilset("enemysheet.xml");
            _iIdSprite = Visu.Instance.getSpriteId(_iIdTexture, "shrapnel");//World.Instance.getGraphicID("SpriteShrapnel");
            _iIdAnimationExplosion = Visu.Instance.getAnimationID("Little_Explosion");//World.Instance.getGraphicID("LittleExplosion");

            _shape.resize(Visu.Instance.getSpriteWidth(_iIdTexture, _iIdSprite), Visu.Instance.getSpriteHeight(_iIdTexture, _iIdSprite));
            _shape._iGroup = (int)ePhysicGroup.ePhysicEnemy;

            int width = Visu.Instance.getSpriteWidth(_iIdTexture, _iIdSprite);
            int height = Visu.Instance.getSpriteHeight(_iIdTexture, _iIdSprite);
            _v2AnimationOffset = new Vector2(width / 2, height / 2);

            base.init();
        }

        /// <summary>
        /// Activator
        /// </summary>
        /// <param name="idTexture"></param>
        /// <param name="idSprite"></param>
        /// <param name="position"></param>
        /// <param name="speed"></param>
        public void activate(Vector2 position, Vector2 speed)
        {
            _v2Position = position;
            _v2Speed = speed;
            _bPreState = true;
            _bActive = true;
            _shape._bCollisionEnable = true;
            
        }

        /// <summary>
        /// Update
        /// </summary>
        public override void update()
        {
            if (_bPreState)
            {
                _bPreState = false;
                _iBirthTime = TimeClock.Clock.instance.millisecs;
            }

            float fElapsedTime = TimeClock.Clock.instance.millisecs - _iBirthTime;
            float fRatio = fElapsedTime / ACCELERATION_LIFE_TIME;
            float speedY = _v2Speed.Y * fRatio;

            _v2Position.X += _v2Speed.X;
            _v2Position.Y += speedY;
            _shape._v2position = _v2Position;

            const int PHYSIC_GROUP = (int)ePhysicGroup.ePhysicPlatform | (int)ePhysicGroup.ePhysicPlayer;
            CollisionResult res = Physics.Physics.Instance.checkFirstRegisteredCollisionEx(_shape, PHYSIC_GROUP);
            if (res != null)
            {
                die();
                if (res.Entity.EntityType == eEntityType.eEntityPlayer)
                {
                    World.Instance.PlayerEntity.hurt(_iDamages);
                }
            }
        }

        public override void render()
        {
            Visu.Instance.displaySprite(_iIdTexture, _iIdSprite, ScreenPosition);
        }

        public override void die()
        {
            _shape._bCollisionEnable = false;
            _bActive = false;
            Manager.ExplosionManager.Instance.activate(_iIdAnimationExplosion, Position + _v2AnimationOffset);
        }

        public override void hurt(int damages)
        {
            die();
        }
    }
}
